/******************************************************************************/
#include "stdafx.h"
/******************************************************************************/
MusicTheme *mt_battle  , // music themes
           *mt_explore ;
Sound       sound      ; // sound
Slider      vol_fx     , // volume bars
            vol_music  ,
            vol_ambient;
Text       tvol_fx     , // volume text
           tvol_music  ,
           tvol_ambient;
/******************************************************************************/
void InitPre()
{
   App.name="Volume groups";
   App.flag=APP_NO_FX;
   PakAdd("../data/engine.pak");
}
/******************************************************************************/
Bool Init()
{
   Gui.tds_text.scale*=1.5f; // make all Text objects bigger

   if(mt_battle=MusicThemeNew()) // create mt_battle theme
   {
      *mt_battle+="../data/music/battle0.ogg"; // add "battle0.ogg" track to 'mt_battle' theme
      *mt_battle+="../data/music/battle1.ogg"; // add "battle0.ogg" track to 'mt_battle' theme
   }
   if(mt_explore=MusicThemeNew()) // create mt_explore theme
   {
      *mt_explore+="../data/music/explore.ogg"; // add "explore.ogg" track to 'mt_explore' theme
   }
   
   Music  .play(mt_battle ); // play theme as music
   Ambient.play(mt_explore); // play theme as ambient
   sound  .play("../data/sound/water.ogg",true); // play looped sound

   Gui+=vol_fx     .create(Rect(-0.1,0.30,0.3,0.40),SoundVolume.fx     ()); Gui+=tvol_fx     .create(Vec2(-0.3,0.35),"Fx");
   Gui+=vol_music  .create(Rect(-0.1,0.15,0.3,0.25),SoundVolume.music  ()); Gui+=tvol_music  .create(Vec2(-0.3,0.20),"Music");
   Gui+=vol_ambient.create(Rect(-0.1,0.00,0.3,0.10),SoundVolume.ambient()); Gui+=tvol_ambient.create(Vec2(-0.3,0.05),"Ambient");
   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   Gui.update();

   // set new volumes
   SoundVolume.fx     (vol_fx     ());
   SoundVolume.music  (vol_music  ());
   SoundVolume.ambient(vol_ambient());
   return true;
}
/******************************************************************************/
void Draw()
{
   D  .clear(WHITE);
   Gui.draw ();
}
/******************************************************************************/
